/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.entity.rule;

import java.sql.Types;

import zigen.plugin.db.core.TableColumn;

public class OracleEntityMappingFactory extends DefaultEntityMappingFactory {
	
	public String getJavaType(TableColumn column) {
		return getJavaType(column.getDataType());
	}
	
	public String getTemporalType(int type) {
		switch (type) {
			
			case Types.TIME:
				return "TemporalType.TIME"; //$NON-NLS-1$
				
			case Types.DATE:
				// return "TemporalType.DATE"; //$NON-NLS-1$
				return "TemporalType.TIMESTAMP"; //$NON-NLS-1$
				
			case Types.TIMESTAMP:
				return "TemporalType.TIMESTAMP"; //$NON-NLS-1$
				
			default:
				return null;
		}
	}
	
	public String getJavaType(int type) {
		switch (type) {
			case Types.TIME:
				return "java.sql.Time"; //$NON-NLS-1$
				
			case Types.DATE:
				// return "java.sql.Date"; //$NON-NLS-1$
				
				// OracleではDate型でもTimestamp型とする
				return "java.sql.Timestamp"; //$NON-NLS-1$
				

			case Types.TIMESTAMP:
				return "java.sql.Timestamp"; //$NON-NLS-1$
				

			default:
				return super.getJavaType(type);
		}
	}
	
}